--Loadouts database
-------------------------------------------------------------------------------------------------------

--[[ Loadout Entry Example ----------------------------------------------------------------------------

["MiG-21Bis"] = {														--String, aircraft type
	["Strike"] = {														--String, task
		["Custom Loadout Name"] = {										--String, custom loadout name
			support = {													--Table, list of tasks that can support this loadout (nil = is never added, true = is added when available)
				["Escort"] = true,										--Fighter escort
				["SEAD"] = true,										--SEAD	escort
				["Escort Jammer"] = true,								--Jammer escort
				["Flare Illumination"] = true,							--Target area flare illumination (mandatory support for loadout to be eligible)
				["Laser Illumination"] = true,							--Target laser illumination (mandatory support for loadout to be eligible)
			},
			attributes = {												--Array, custom loadout attributes. Only used by A-G tasks. Any target attribute must be matched in this array for the loadout to be eligible for the target.
				[1] = "Anti-tank",										--String, custom attribute to be matched for target attribute
				[2] = "Stand-off Missile",								--String, custom attribute to be matched for target attribute
			},
			weaponType = "Bombs",										--String, type of ordinance of loadout. Only used by A-G taks. Options: "Cannon", "Rockets", "Bombs", "Guided bombs", "ASM". A-G weapon types cannot be mixed.
			expend = "All",												--String, quantity of wapons expended per attack. Only used by A-G tasks. Options: "Auto", "All", "Half", "Two".
			day = true,													--Boolean, loadout is day capable
			night = true,												--Boolean, loadout is night capable
			adverseWeather = true,										--Boolean, loadout is adverse weather capable
			range = 900000,												--Number, range radius in meters
			capability = 10,											--Number, how good is the aircraft with this loadout. The higher the better
			firepower = 10,												--Number, how much firepower has this loadout. The higher the better
			vCruise = 225,												--Number, cruise speed in m/s
			vAttack = 280,												--Number, attack speed in m/s
			hCruise = 6000,												--Number, cruise altitude in m
			hAttack = 100,												--Number, attack altitude in m
			standoff = 5000,											--Number, attack distance from target in m. Determines attack waypoint distance for A-G with missiles (for Bombss use nil) and engage distance for A-A tasks
			tStation = 1200,											--Number, seconds the aircraft can remain on station. Only used by CAP, AWACS and Refuelling tasks
			LDSD = true,												--Boolean, aircraft is Look-Down/Shoot-Down capable. Only used by CAP and Intercept tasks
			self_escort = false,										--Boolean, aircraft can defend itself against fighters. Only used by A-G tasks
			sortie_rate = 2,											--Number, average amount of sorties that aircraft flies per day
			stores = {													--Table, loadout table for DCS
				["pylons"] = 
				{
					[1] = 
					{
						["CLSID"] = "{R-60M 2L}",
					},
					[2] = 
					{
						["CLSID"] = "{R-3R}",
					},
					[3] = 
					{
						["CLSID"] = "{PTB_800_MIG21}",
					},
					[4] = 
					{
						["CLSID"] = "{R-3R}",
					},
					[5] = 
					{
						["CLSID"] = "{R-60M 2R}",
					},
					[6] = 
					{
						["CLSID"] = "{ASO-2}",
					},
				},
				["fuel"] = 2280,
				["flare"] = 32,
				["ammo_type"] = 1,
				["chaff"] = 32,
				["gun"] = 100,
			},
		},
	},
},

]]-----------------------------------------------------------------------------------------------------


db_loadouts = {
	["F-86F Sabre"] = {
		["Intercept"] = {
			["Intercept - 200gal Fuel*2, GAR-8*2"] = {
				attributes = {},
				-- weaponType = nil,
				-- expend = nil,
				day = true,
				night = false,
				adverseWeather = false,
				range = 46300,
				capability = 10,
				firepower = 1,
				-- vCruise = nil,
				-- vAttack = nil,
				-- hCruise = nil,
				-- hAttack = nil,
				-- standoff = nil,
				-- tStation = nil,
				LDSD = false,
				-- self_escort = true,
				sortie_rate = 6,
				stores = {
			["pylons"] = {
				[10] = {
					["CLSID"] = "{PTB_200_F86F35}",
					["num"] = 10,
				},
				[1] = {
					["CLSID"] = "{PTB_200_F86F35}",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "{GAR-8}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{GAR-8}",
					["num"] = 5,
				},
			},
				["fuel"] = 2493,
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
		},
		["Strike"] = {
			["Strike - 200gal Fuel*2, AIM-9*2, HVAR*8"] = {
			    minscore = 0.7,
				support = {
					["Escort"] = false,
					["SEAD"] = false,
				},
				attributes = {"soft", "Parked Aircraft"},
				weaponType = "Rockets",
				expend = "Auto",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 650000,
				capability = 8,
				firepower = 10,
				vCruise = 200,
				vAttack = 300.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = true,
				sortie_rate = 3,
				stores = {
					["pylons"] = {
				[10] = {
					["CLSID"] = "{PTB_200_F86F35}",
					["num"] = 10,
				},
				[1] = {
					["CLSID"] = "{PTB_200_F86F35}",
					["num"] = 1,
				},
				[7] = {
					["CLSID"] = "{HVARx2}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{HVARx2}",
					["num"] = 4,
				},
				[6] = {
					["CLSID"] = "{GAR-8}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{GAR-8}",
					["num"] = 5,
				},
				[3] = {
					["CLSID"] = "{HVARx2}",
					["num"] = 3,
				},
				[8] = {
					["CLSID"] = "{HVARx2}",
					["num"] = 8,
				},
			}, -- end of ["pylons"]
				["fuel"] = 2493,
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
			["Strike - 200gal Fuel*2, AIM-9*2, AN-M64*2"] = {
			    minscore = 0.7,
				support = {
					["Escort"] = false,
					["SEAD"] = false,
				},
				attributes = {"soft", "Parked Aircraft", "Structure"},
				weaponType = "Bombs",
				expend = "All",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 650000,
				capability = 8,
				firepower = 10,
				vCruise = 200,
				vAttack = 300.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = true,
				sortie_rate = 3,
				stores = {
					["pylons"] = {
				[10] = {
					["CLSID"] = "{PTB_200_F86F35}",
					["num"] = 10,
				},
				[1] = {
					["CLSID"] = "{PTB_200_F86F35}",
					["num"] = 1,
				},
				[7] = {
					["CLSID"] = "{F86ANM64}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{F86ANM64}",
					["num"] = 4,
				},
				[6] = {
					["CLSID"] = "{GAR-8}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{GAR-8}",
					["num"] = 5,
				},
			}, -- end of ["pylons"]
				["fuel"] = 2493,
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
			["Strike - AIM-9*2, HVAR*16"] = {
			    minscore = 0.7,
				support = {
					["Escort"] = false,
					["SEAD"] = false,
				},
				attributes = {"soft", "Parked Aircraft"},
				weaponType = "Rockets",
				expend = "Auto",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 650000,
				capability = 8,
				firepower = 10,
				vCruise = 200,
				vAttack = 300.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = true,
				sortie_rate = 3,
				stores = {
					["pylons"] = {
				[10] = {
					["CLSID"] = "{HVARx2}",
					["num"] = 10,
				},
				[1] = {
					["CLSID"] = "{HVARx2}",
					["num"] = 1,
				},
				[7] = {
					["CLSID"] = "{HVARx2}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{HVARx2}",
					["num"] = 4,
				},
				[6] = {
					["CLSID"] = "{GAR-8}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{GAR-8}",
					["num"] = 5,
				},
				[8] = {
					["CLSID"] = "{HVARx2}",
					["num"] = 8,
				},
				[3] = {
					["CLSID"] = "{HVARx2}",
					["num"] = 3,
				},
				[9] = {
					["CLSID"] = "{HVARx2}",
					["num"] = 9,
				},
				[2] = {
					["CLSID"] = "{HVARx2}",
					["num"] = 2,
				},
			}, -- end of ["pylons"]
				["fuel"] = 1281,
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
		},
	},
	["F-16C bl.52d"] = {
		["Intercept"] = {
			[" AIM-120B*4, AIM-9M*2, FT*1"] = {
				attributes = {},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 10,
				firepower = 1,
				-- vCruise = 270,
				-- vAttack = 270,
				-- hCruise = 6096,
				-- hAttack = 6096,
				-- standoff = 45000,
				-- tStation = nil,
				LDSD = true,
				-- --- self_escort = true,
				sortie_rate = 2,
				stores = {
					["pylons"] = 
					{
					[6] = {
						["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
						["num"] = 6,
					},
					[8] = {
						["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
						["num"] = 8,
					},
					[9] = {
						["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
						["num"] = 9,
					},
					[10] = {
						["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
						["num"] = 10,
					},
					[3] = {
						["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
						["num"] = 3,
					},
					[2] = {
						["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
						["num"] = 2,
					},
					[1] = {
						["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
						["num"] = 1,
					},
					}, -- end of ["pylons"]
					["fuel"] = 4014,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
		},
		["CAP"] = {
			["AIM-120B*4, AIM-9M*2, FT*3"] = {
				attributes = {"Air Forces"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 5,
				firepower = 1,
				vCruise = 255.83333333333,
				vAttack = 265.83333333333,
				hCruise = 7620,
				hAttack = 7620,
				standoff = 46300,
				tStation = 7200,
				LDSD = true,
				--- self_escort = true,
				sortie_rate = 5,
				stores = {
				["pylons"] = 
				{
				[7] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 4,
				},
				[6] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 6,
				},
				[8] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 8,
				},
				[9] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 9,
				},
				[10] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 10,
				},
				[3] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 3,
				},
				[2] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 2,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				}, -- end of ["pylons"]
				["fuel"] = 6259,
				["flare"] = 60,
				["chaff"] = 60,
				["gun"] = 100,
				},
			},
		},
		["SEAD"] = {
			["AGM-45*2, AIM-9M*2, AIM-120B*2, ECM*1, Fuel*2"] = {
				attributes = {},
				weaponType = "ASM",
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 10,
				firepower = 10,
				vCruise = 270,
				vAttack = 270,
				hCruise = 6096,
				hAttack = 6096,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = true,
				sortie_rate = 8,
				stores = {
				["pylons"] = {
				[10] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 10,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[9] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 9,
				},
				[2] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 2,
				},
				[8] = {
					["CLSID"] = "{3E6B632D-65EB-44D2-9501-1C2D04515405}",
					["num"] = 8,
				},
				[3] = {
					["CLSID"] = "{3E6B632D-65EB-44D2-9501-1C2D04515405}",
					["num"] = 3,
				},
				[7] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 4,
				},
				[6] = {
					["CLSID"] = "ALQ_184",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{CAAC1CFD-6745-416B-AFA4-CB57414856D0}",
					["num"] = 5,
				},
				}, -- end of ["pylons"]
 				["fuel"] = 5349,
				["flare"] = 45,
				["chaff"] = 90,
				["gun"] = 100,
				},
			},	
		},
	},
	["F-16C_50"] = {
		["Intercept"] = {
			[" AIM-120B*4, AIM-9M*2, FT*3"] = {
				attributes = {},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 10,
				firepower = 1,
				-- vCruise = 270,
				-- vAttack = 270,
				-- hCruise = 6096,
				-- hAttack = 6096,
				-- standoff = 45000,
				-- tStation = nil,
				LDSD = true,
				-- --- self_escort = true,
				sortie_rate = 10,
				stores = {
					["pylons"] = 
					{
				[9] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[8] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 3,
				},
				[6] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
					}, -- end of ["pylons"]
					["fuel"] = 6404,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
		},
		["CAP"] = {
			["AIM-120B*4, AIM-9M*2, FT*3"] = {
				attributes = {"Air Forces"},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 10,
				firepower = 1,
				vCruise = 255.83333333333,
				vAttack = 265.83333333333,
				hCruise = 7620,
				hAttack = 7620,
				standoff = 46300,
				tStation = 7200,
				LDSD = true,
				--- self_escort = true,
				sortie_rate = 10,
				stores = {
				["pylons"] = 
				{
				[9] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[8] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 3,
				},
				[6] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				}, -- end of ["pylons"]
				["fuel"] = 6404,
				["flare"] = 60,
				["chaff"] = 60,
				["gun"] = 100,
				},
			},
		},
		["Escort"] = {
			["AIM-120B*4, AIM-9M*2, FT*3"] = {
				attributes = {},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 10,
				firepower = 10,
				vCruise = 255.83333333333,
				-- vAttack = 265.83333333333,
				-- hCruise = 9753.6,
				-- hAttack = 9753.6,
				standoff = 46300,
				tStation = nil,
				LDSD = true,
				--- self_escort = true,
				sortie_rate = 6,
				stores = {
				["pylons"] = 
				{
				[9] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[8] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 3,
				},
				[6] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				}, -- end of [11]
				}, -- end of ["pylons"]
				["fuel"] = 6404,
				["flare"] = 60,
				["chaff"] = 60,
				["gun"] = 100,
				},
			},
		},			
		["Strike"] = {
			["Strike GBU-12*4, AIM-120B*2, AIM-9M*2, FUEL*3, TP"] = {
				minscore = 1,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"Bridge", "Structure", "base"},
				weaponType = "Guided bombs",
				expend = "Auto",
				day = true,
				night = false,
				adverseWeather = false,
				range = 500000,
				capability = 8,
				firepower = 10,
				vCruise = 215.83333333333,
				vAttack = 277.5,
				hCruise = 7000,
				hAttack = 7100,
				standoff = nil,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 5,
				stores = {
			["pylons"] = {
				[9] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[8] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{TER_9A_2R*GBU-12}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{TER_9A_2R*GBU-12}",
					["num"] = 3,
				},
				[6] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				[11] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 11,
				}, -- end of [11]
				}, -- end of ["pylons"]
					["fuel"] = 6404,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["Mk-82*6, AIM-120B*2, AIM-9M*2, FUEL*3, Pod"] = {
				minscore = 1,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = true,
				adverseWeather = false,
				range = 500000,
				capability = 8,
				firepower = 10,
				vCruise = 215.83333333333,
				vAttack = 277.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 5,
				stores = {
					["pylons"] = 
					{
				[9] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[8] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{TER_9A_3*MK-82}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{TER_9A_3*MK-82}",
					["num"] = 3,
				},
				[6] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				[11] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 11,
				}, -- end of [10]
					}, -- end of ["pylons"]
					["fuel"] = 6404,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},
			["CBU-97*4, AIM-120B*2, AIM-9M*2, FT*3,pod"] = {
				minscore = 1,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
				},
				attributes = {"soft", "SAM"},
				weaponType = "Bombs",
				expend = "All",
				day = true,
				night = true,
				adverseWeather = false,
				range = 500000,
				capability = 8,
				firepower = 10,
				vCruise = 215.83333333333,
				vAttack = 277.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = true,
				--- self_escort = false,
				sortie_rate = 5,
				stores = {
					["pylons"] = 
					{
				[9] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 9,
				},
				[1] = {
					["CLSID"] = "{6CEB49FC-DED8-4DED-B053-E1F033FF72D3}",
					["num"] = 1,
				},
				[8] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{C8E06185-7CD6-4C90-959F-044679E90751}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{TER_9A_2R*CBU-97}",
					["num"] = 7,
				},
				[3] = {
					["CLSID"] = "{TER_9A_2R*CBU-97}",
					["num"] = 3,
				},
				[6] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 6,
				},
				[4] = {
					["CLSID"] = "{F376DBEE-4CAE-41BA-ADD9-B2910AC95DEC}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{8A0BE8AE-58D4-4572-9263-3144C0D06364}",
					["num"] = 5,
				},
				[11] = {
					["CLSID"] = "{A111396E-D3E8-4b9c-8AC9-2432489304D5}",
					["num"] = 11,
				}, -- end of [11]
				}, -- end of ["pylons"]
					["fuel"] = 6403,
					["flare"] = 60,
					["chaff"] = 60,
					["gun"] = 100,
				},
			},	
		},
	},
	["MiG-19P"] = {
		["Intercept"] = {
			["Intercept - K-13A*2"] = {
				attributes = {},
				-- weaponType = nil,
				-- expend = nil,
				day = true,
				night = false,
				adverseWeather = false,
				range = 46300,
				capability = 10,
				firepower = 1,
				-- vCruise = nil,
				-- vAttack = nil,
				-- hCruise = nil,
				-- hAttack = nil,
				-- standoff = nil,
				-- tStation = nil,
				LDSD = false,
				-- self_escort = true,
				sortie_rate = 8,
				stores = {
			["pylons"] = {
				[6] = {
					["CLSID"] = "{K-13A}",
					["num"] = 6,
				},
				[1] = {
					["CLSID"] = "{K-13A}",
					["num"] = 1,
				},
			},
				["fuel"] = 1800,
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
				["AddPropAircraft"] = 
                                        {
                                            ["MissileToneVolume"] = 5,
                                            ["NAV_Initial_Hdg"] = 0,
                                            ["ADF_Selected_Frequency"] = 1,
                                            ["ADF_NEAR_Frequency"] = 303,
                                            ["ADF_FAR_Frequency"] = 625,
                                            ["MountSIRENA"] = true,
                                        }, -- end of ["AddPropAircraft"]
			},
		},
		["Strike"] = {
			["Strike - K-13A*2, FAB-250*2"] = {
			minscore = 0.7,
				support = {
					["Escort"] = false,
					["SEAD"] = false,
				},
				attributes = {"soft", "Parked Aircraft", "Structure"},
				weaponType = "Bombs",
				expend = "All",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 650000,
				capability = 8,
				firepower = 10,
				vCruise = 200,
				vAttack = 300.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = true,
				sortie_rate = 3,
				stores = {
					["pylons"] = {
				[6] = {
					["CLSID"] = "{K-13A}",
					["num"] = 6,
				},
				[1] = {
					["CLSID"] = "{K-13A}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
					["num"] = 2,
				},
			}, -- end of ["pylons"]
				["fuel"] = 1800,
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
				["AddPropAircraft"] = 
                                        {
                                            ["MissileToneVolume"] = 5,
                                            ["NAV_Initial_Hdg"] = 0,
                                            ["ADF_Selected_Frequency"] = 1,
                                            ["ADF_NEAR_Frequency"] = 303,
                                            ["ADF_FAR_Frequency"] = 625,
                                            ["MountSIRENA"] = true,
                                        }, -- end of ["AddPropAircraft"]
			},
			["Strike SR - K-13A*2, ORO-57K*4"] = {
			minscore = 0.7,
				support = {
					["Escort"] = false,
					["SEAD"] = false,
				},
				attributes = {"soft", "Parked Aircraft"},
				weaponType = "Rockets",
				expend = "Auto",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 650000,
				capability = 8,
				firepower = 10,
				vCruise = 200,
				vAttack = 300.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = true,
				sortie_rate = 3,
				stores = {
					["pylons"] = {
				[6] = {
					["CLSID"] = "{K-13A}",
					["num"] = 6,
				},
				[1] = {
					["CLSID"] = "{K-13A}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "{ORO57K_S5M_HEFRAG}",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "{ORO57K_S5M_HEFRAG}",
					["num"] = 2,
				},
				[4] = {
					["CLSID"] = "{ORO57K_S5M_HEFRAG}",
					["num"] = 4,
				},
				[3] = {
					["CLSID"] = "{ORO57K_S5M_HEFRAG}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
				["fuel"] = 1800,
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
				["AddPropAircraft"] = 
                                        {
                                            ["MissileToneVolume"] = 5,
                                            ["NAV_Initial_Hdg"] = 0,
                                            ["ADF_Selected_Frequency"] = 1,
                                            ["ADF_NEAR_Frequency"] = 303,
                                            ["ADF_FAR_Frequency"] = 625,
                                            ["MountSIRENA"] = true,
                                        }, -- end of ["AddPropAircraft"]
			},
			["Strike - K-13A*2, PTB-760*2, ORO-57K*2"] = {
				minscore = 0.7,
				support = {
					["Escort"] = false,
					["SEAD"] = false,
				},
				attributes = {"soft", "Parked Aircraft"},
				weaponType = "Rockets",
				expend = "Auto",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 650000,
				capability = 8,
				firepower = 10,
				vCruise = 200,
				vAttack = 300.5,
				hCruise = 5486.4,
				hAttack = 4572,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = true,
				sortie_rate = 3,
				stores = {
					["pylons"] = {
				[6] = {
					["CLSID"] = "{K-13A}",
					["num"] = 6,
				},
				[1] = {
					["CLSID"] = "{K-13A}",
					["num"] = 1,
				},
				[5] = {
					["CLSID"] = "PTB760_MIG19",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "PTB760_MIG19",
					["num"] = 2,
				},
				[4] = {
					["CLSID"] = "{ORO57K_S5M_HEFRAG}",
					["num"] = 4,
				},
				[3] = {
					["CLSID"] = "{ORO57K_S5M_HEFRAG}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
				["fuel"] = 3062,
                ["flare"] = 0,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
				["AddPropAircraft"] = 
                                        {
                                            ["MissileToneVolume"] = 5,
                                            ["NAV_Initial_Hdg"] = 0,
                                            ["ADF_Selected_Frequency"] = 1,
                                            ["ADF_NEAR_Frequency"] = 303,
                                            ["ADF_FAR_Frequency"] = 625,
                                            ["MountSIRENA"] = true,
                                        }, -- end of ["AddPropAircraft"]
			},
		},
	},
	["SA342M"] = {
		["Strike"] = {
			["Strike Hot3x4, IR Deflector"] = {
				minscore = 0.5,
					support = {
						["Escort"] = false,
						["SEAD"] = false,
					},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				weaponType = "ASM",
				expend = "Auto",
				day = true,
				night = true,
				adverseWeather = true,
				range = 120000,
				capability = 10,
				firepower = 1,
				vCruise = 53,
				vAttack = 72,
				hCruise = 50,
				hAttack = 50,
				standoff = 4000,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[1] = {
					["CLSID"] = "{HOT3D}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{HOT3G}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{HOT3D}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{HOT3G}",
					["num"] = 4,
				},
				[6] = {
					["CLSID"] = "{IR_Deflector}",
					["num"] = 6,
				},
			}, -- end of ["pylons"]
                ["fuel"] = 416,
                ["flare"] = 32,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
		},
	},
	["UH-1H"] = {
		["Strike"] = {
			["Strike Gunship"] = {
				minscore = 0.5,
					support = {
						["Escort"] = false,
						["SEAD"] = false,
					},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				weaponType = "Rockets",
				expend = "Auto",
				day = true,
				night = true,
				adverseWeather = true,
				range = 92600,
				capability = 10,
				firepower = 1,
				vCruise = 35,
				vAttack = 45,
				hCruise = 50,
				hAttack = 50,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[5] = {
					["CLSID"] = "M261_MK151",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "M261_MK151",
					["num"] = 2,
				},
				[1] = {
					["CLSID"] = "M134_L",
					["num"] = 1,
				},
				[6] = {
					["CLSID"] = "M134_R",
					["num"] = 6,
				},
			}, -- end of ["pylons"]
                ["fuel"] = 631,
                ["flare"] = 60,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
				["AddPropAircraft"] = 
                    {
                        ["NetCrewControlPriority"] = 1,
                        ["GunnersAISkill"] = 90,
                        ["EngineResource"] = 90,
                        ["ExhaustScreen"] = true,
                    }, -- end of ["AddPropAircraft"]
			},
			["Strike Guns"] = {
				minscore = 0.5,
					support = {
						["Escort"] = false,
						["SEAD"] = false,
					},
				attributes = {"soft", "Parked Aircraft"},
				weaponType = "Rockets",
				expend = "Auto",
				day = true,
				night = true,
				adverseWeather = true,
				range = 92600,
				capability = 10,
				firepower = 1,
				vCruise = 35,
				vAttack = 45,
				hCruise = 50,
				hAttack = 50,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[6] = {
					["CLSID"] = "M134_R",
					["num"] = 6,
				},
				[1] = {
					["CLSID"] = "M134_L",
					["num"] = 1,
				},
				[3] = {
					["CLSID"] = "M60_SIDE_L",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "M60_SIDE_R",
					["num"] = 4,
				},
			}, -- end of ["pylons"]
                ["fuel"] = 631,
                ["flare"] = 60,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
				["AddPropAircraft"] = 
                    {
                        ["NetCrewControlPriority"] = 1,
                        ["GunnersAISkill"] = 90,
                        ["EngineResource"] = 90,
                        ["ExhaustScreen"] = true,
                    }, -- end of ["AddPropAircraft"]
			},
			["Strike Rockets"] = {
				minscore = 0.5,
					support = {
						["Escort"] = false,
						["SEAD"] = false,
					},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				weaponType = "Rockets",
				expend = "Auto",
				day = true,
				night = true,
				adverseWeather = true,
				range = 92600,
				capability = 10,
				firepower = 1,
				vCruise = 35,
				vAttack = 45,
				hCruise = 50,
				hAttack = 50,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[5] = {
					["CLSID"] = "M261_MK151",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "M261_MK151",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "M60_SIDE_L",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "M60_SIDE_R",
					["num"] = 4,
				},
			}, -- end of ["pylons"]
                ["fuel"] = 631,
                ["flare"] = 60,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
				["AddPropAircraft"] = 
                    {
                        ["NetCrewControlPriority"] = 1,
                        ["GunnersAISkill"] = 90,
                        ["EngineResource"] = 90,
                        ["ExhaustScreen"] = true,
                    }, -- end of ["AddPropAircraft"]
			},
		},
	},
	["Su-25"] = {
		["SEAD"] = {
			["SEAD"] = {
				attributes = {},
				weaponType = "ASM",
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 10,
				firepower = 10,
				vCruise = 166.67,
				vAttack = 180.56,
				hCruise = 6096,
				hAttack = 6096,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = true,
				sortie_rate = 6,
				stores = {
				["pylons"] = {
				[9] = {
					["CLSID"] = "{0180F983-C14A-11d8-9897-000476191836}",
					["num"] = 9,
				},
				[8] = {
					["CLSID"] = "{0180F983-C14A-11d8-9897-000476191836}",
					["num"] = 8,
				},
				[2] = {
					["CLSID"] = "{0180F983-C14A-11d8-9897-000476191836}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{0180F983-C14A-11d8-9897-000476191836}",
					["num"] = 3,
				},
				[7] = {
					["CLSID"] = "{0180F983-C14A-11d8-9897-000476191836}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{0180F983-C14A-11d8-9897-000476191836}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{E8D4652F-FD48-45B7-BA5B-2AE05BB5A9CF}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{E8D4652F-FD48-45B7-BA5B-2AE05BB5A9CF}",
					["num"] = 6,
				},
				}, -- end of ["pylons"]
 				["fuel"] = 4075,
				["flare"] = 128,
				["chaff"] = 128,
				["gun"] = 100,
				},
			},	
		},
		["Strike"] = {
			["Bombs"] = {
			    minscore = 0.5,
				support = {
					["Escort"] = false,
					["SEAD"] = false,
				},
				attributes = {"soft", "Parked Aircraft", "Structure"},
				weaponType = "Bombs",
				expend = "Auto",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 650000,
				capability = 8,
				firepower = 10,
				vCruise = 166.67,
				vAttack = 180.56,
				hCruise = 6096,
				hAttack = 609.6,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = true,
				sortie_rate = 3,
				stores = {
					["pylons"] = {
				[9] = {
					["CLSID"] = "{29A828E2-C6BB-11d8-9897-000476191836}",
					["num"] = 9,
				},
				[2] = {
					["CLSID"] = "{29A828E2-C6BB-11d8-9897-000476191836}",
					["num"] = 2,
				},
				[7] = {
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{E8D4652F-FD48-45B7-BA5B-2AE05BB5A9CF}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{E8D4652F-FD48-45B7-BA5B-2AE05BB5A9CF}",
					["num"] = 6,
				},
				[3] = {
					["CLSID"] = "{D5435F26-F120-4FA3-9867-34ACE562EF1B}",
					["num"] = 3,
				},
				[8] = {
					["CLSID"] = "{D5435F26-F120-4FA3-9867-34ACE562EF1B}",
					["num"] = 8,
				},
			}, -- end of ["pylons"]
				["fuel"] = 4075,
                ["flare"] = 128,
                ["chaff"] = 128,
                ["gun"] = 100,
				},
			},
			["Rockets"] = {
			    minscore = 0.5,
				support = {
					["Escort"] = false,
					["SEAD"] = false,
				},
				attributes = {"soft", "Parked Aircraft", "Structure"},
				weaponType = "Rockets",
				expend = "All",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 650000,
				capability = 8,
				firepower = 10,
				vCruise = 166.67,
				vAttack = 180.56,
				hCruise = 3050,
				hAttack = 610,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				--- self_escort = true,
				sortie_rate = 3,
				stores = {
					["pylons"] = {
				[9] = {
					["CLSID"] = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}",
					["num"] = 9,
				},
				[2] = {
					["CLSID"] = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}",
					["num"] = 3,
				},
				[8] = {
					["CLSID"] = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}",
					["num"] = 8,
				},
				[7] = {
					["CLSID"] = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{F72F47E5-C83A-4B85-96ED-D3E46671EE9A}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{E8D4652F-FD48-45B7-BA5B-2AE05BB5A9CF}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{E8D4652F-FD48-45B7-BA5B-2AE05BB5A9CF}",
					["num"] = 6,
				},
			}, -- end of ["pylons"]
				["fuel"] = 4075,
                ["flare"] = 128,
                ["chaff"] = 128,
                ["gun"] = 100,
				},
			},
		},
	},
	["Su-24M"] = {
		["Strike"] = {
			["Bombs"] = {
				minscore = 1,
				support = {
					["Escort"] = true,
					["SEAD"] = true,
					},
				attributes = {"soft", "Parked Aircraft", "Structure"},
				weaponType = "Bombss",
				expend = "All",
				attackType = "Dive",
				day = true,
				night = true,
				adverseWeather = true,
				range = 900000,
				capability = 10,
				firepower = 10,
				vCruise = 250,
				vAttack = 350,
				hCruise = 7620,
				hAttack = 7620,
				standoff = nil,
				self_escort = false,
				sortie_rate = 3,
				stores = {
				["pylons"] = 
                {
					[8] = {
						["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
						["num"] = 8,
					},
					[7] = {
						["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
						["num"] = 7,
					},
					[6] = {
						["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
						["num"] = 6,
					},
					[5] = {
						["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
						["num"] = 5,
					},
					[3] = {
						["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
						["num"] = 3,
					},
					[2] = {
						["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
						["num"] = 2,
					},
					[1] = {
						["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
						["num"] = 1,
					},
					[4] = {
						["CLSID"] = "{3C612111-C7AD-476E-8A8E-2485812F4E5C}",
						["num"] = 4,
					},
                }, -- end of ["pylons"]	
				["fuel"] = 11700,
                ["flare"] = 96,
                ["chaff"] = 96,
                ["gun"] = 100,
				},
			},
		},
	},
	["MiG-21Bis"] = {
		["Intercept"] = {
			["Intercept"] = {
				attributes = {},
				weaponType = nil,
				expend = nil,
				day = true,
				night = false,
				adverseWeather = false,
				range = 55560,
				capability = 8,
				firepower = 1,
				vCruise = nil,
				vAttack = nil,
				hCruise = nil,
				hAttack = nil,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 4,
				stores = {
				["pylons"] = {
					[5] = {
						["CLSID"] = "{R-60M 2R}",
						["num"] = 5,
					},
					[4] = {
						["CLSID"] = "{R-3R}",
						["num"] = 4,
					},
					[2] = {
						["CLSID"] = "{R-3R}",
						["num"] = 2,
					},
					[1] = {
						["CLSID"] = "{R-60M 2L}",
						["num"] = 1,
					},
					[3] = {
						["CLSID"] = "{PTB_800_MIG21}",
						["num"] = 3,
					},
					[6] = {
						["CLSID"] = "{ASO-2}",
						["num"] = 6,
					},
			}, -- end of ["pylons"]
					["fuel"] = 2280,
					["flare"] = 32,
					["chaff"] = 32,
					["gun"] = 100,
				},
			},
		},
		["Escort"] = {
			["Escort"] = {
				attributes = {},
				weaponType = nil,
				expend = nil,
				day = true,
				night = false,
				adverseWeather = false,
				range = 700000,
				capability = 8,
				firepower = 10,
				vCruise = 200,
				-- vAttack = 350,
				-- hCruise = 7500,
				-- hAttack = 5500,
				standoff = 10000,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 4,
				stores = {
				["pylons"] = {
					[5] = {
						["CLSID"] = "{R-60M 2R}",
						["num"] = 5,
					},
					[4] = {
						["CLSID"] = "{R-3R}",
						["num"] = 4,
					},
					[2] = {
						["CLSID"] = "{R-3R}",
						["num"] = 2,
					},
					[1] = {
						["CLSID"] = "{R-60M 2L}",
						["num"] = 1,
					},
					[3] = {
						["CLSID"] = "{PTB_800_MIG21}",
						["num"] = 3,
					},
					[6] = {
						["CLSID"] = "{ASO-2}",
						["num"] = 6,
					},
			}, -- end of ["pylons"]
					["fuel"] = 2280,
					["flare"] = 32,
					["chaff"] = 32,
					["gun"] = 100,
				},
			},
		},
		["Strike"] = {
			["Bombs"] = {
				minscore = 0.7,
				support = {
						["Escort"] = false,
						["SEAD"] = false,
					},
				attributes = {"soft", "Parked Aircraft", "Structure"},
				weaponType = "Bombs",
				expend = "All",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 700000,
				capability = 8,
				firepower = 10,
				vCruise = 200,
				vAttack = 250,
				hCruise = 4572,
				hAttack = 609.6,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 2,
				stores = {
				["pylons"] = {
				[5] = {
					["CLSID"] = "{R-3R}",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
					["num"] = 2,
				},
				[4] = {
					["CLSID"] = "{37DCC01E-9E02-432F-B61D-10C166CA2798}",
					["num"] = 4,
				},
				[1] = {
					["CLSID"] = "{R-3R}",
					["num"] = 1,
				},
				[3] = {
					["CLSID"] = "{PTB_800_MIG21}",
					["num"] = 3,
				},
				[6] = {
						["CLSID"] = "{ASO-2}",
						["num"] = 6,
					},
			}, -- end of ["pylons"]
                ["fuel"] = 2280,
					["flare"] = 32,
					["chaff"] = 32,
					["gun"] = 100,
				},
			},
			["Rockets"] = {
				minscore = 0.7,
				support = {
						["Escort"] = false,
						["SEAD"] = false,
					},
				attributes = {"soft", "Parked Aircraft"},
				weaponType = "Rockets",
				expend = "All",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 700000,
				capability = 8,
				firepower = 10,
				vCruise = 200,
				vAttack = 250,
				hCruise = 1500,
				hAttack = 609.6,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 2,
				stores = {
				["pylons"] = {
				[5] = {
					["CLSID"] = "{R-3R}",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "{UB-16_S5M}",
					["num"] = 2,
				},
				[4] = {
					["CLSID"] = "{UB-16_S5M}",
					["num"] = 4,
				},
				[1] = {
					["CLSID"] = "{R-3R}",
					["num"] = 1,
				},
				[3] = {
					["CLSID"] = "{PTB_800_MIG21}",
					["num"] = 3,
				},
				[6] = {
						["CLSID"] = "{ASO-2}",
						["num"] = 6,
					},
			}, -- end of ["pylons"]
                ["fuel"] = 2280,
				["flare"] = 32,
				["chaff"] = 32,
				["gun"] = 100,
				},
			},
		},		
	},
	["MiG-15bis"] = {
		["Intercept"] = {
			["Day"] = {
				attributes = {},
				weaponType = nil,
				expend = nil,
				day = true,
				night = false,
				adverseWeather = false,
				range = 46300,
				capability = 8,
				firepower = 1,
				vCruise = nil,
				vAttack = nil,
				hCruise = nil,
				hAttack = nil,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 3,
				stores = {
				["pylons"] = {
					[1] = {
						["CLSID"] = "PTB600_MIG15",
						["num"] = 2,
					},
					[2] = {
						["CLSID"] = "PTB600_MIG15",
						["num"] = 1,
					},
				}, -- end of ["pylons"]
				["fuel"] = 2168,
				["flare"] = 0,
				["chaff"] = 0,
				["gun"] = 100,
				},
			},
		},
		["Strike"] = {
			["CAS, FAB-100*2"] = {
				minscore = 0.7,
				support = {
					["Escort"] = false,
					["SEAD"] = false,
				},
				attributes = {"soft", "hard", "Structure"},
				weaponType = "Bombs",
				expend = "All",
				attackType = "Dive",
				day = true,
				night = false,
				adverseWeather = false,
				range = 360000,
				capability = 8,
				firepower = 10,
				vCruise = 194.44444444444,
				vAttack = 236.11111111111,
				hCruise = 3500,
				hAttack = 457.2,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 3,
				stores = {
				["pylons"] = {
					[1] = {
						["CLSID"] = "FAB_100M",
						["num"] = 2,
					},
					[2] = {
						["CLSID"] = "FAB_100M",
						["num"] = 1,
					},
				}, -- end of ["pylons"]
				["fuel"] = 1172,
				["flare"] = 0,
				["chaff"] = 0,
				["gun"] = 100,
				},
			},
		},
	},
	["MiG-29A"] = {
		["Intercept"] = {
			["Intercept"] = {
				attributes = {},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 200000,
				capability = 10,
				firepower = 1,
				vCruise = nil,
				vAttack = nil,
				hCruise = nil,
				hAttack = nil,
				standoff = nil,
				tStation = nil,
				LDSD = true,
				self_escort = false,
				sortie_rate = 5,
				stores = {
				["pylons"] = 
				{
					[7] = {
						["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
						["num"] = 7,
					},
					[1] = {
						["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
						["num"] = 1,
					},
					[6] = {
						["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
						["num"] = 6,
					},
					[2] = {
						["CLSID"] = "{682A481F-0CB5-4693-A382-D00DD4A156D7}",
						["num"] = 2,
					},
					[3] = {
						["CLSID"] = "{9B25D316-0434-4954-868F-D51DB1A38DF0}",
						["num"] = 3,
					},
					[5] = {
						["CLSID"] = "{9B25D316-0434-4954-868F-D51DB1A38DF0}",
						["num"] = 5,
					},
				}, -- end of ["pylons"]
				["fuel"] = 3380,
				["flare"] = 30,
				["chaff"] = 30,
				["gun"] = 100,
				},
				},
			},
		["CAP"] = {
			["CAP"] = {
				attributes = {},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 300000,
				capability = 8,
				firepower = 1,
				vCruise = 180.55,
				vAttack = 222.22,
				hCruise = 6096,
				hAttack = 6096,
				standoff = 45000,
				tStation = 3000,
				LDSD = true,
				self_escort = false,
				sortie_rate = 5,
				stores = {
				["pylons"] = 
				{
					[7] = {
						["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
						["num"] = 7,
					},
					[1] = {
						["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
						["num"] = 1,
					},
					[6] = {
						["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
						["num"] = 6,
					},
					[2] = {
						["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
						["num"] = 2,
					},
					[3] = {
						["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
						["num"] = 3,
					},
					[5] = {
						["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
						["num"] = 5,
					},
					[4] = {
						["CLSID"] = "{2BEC576B-CDF5-4B7F-961F-B0FA4312B841}",
						["num"] = 4,
					},
				}, -- end of ["pylons"]
				["fuel"] = 3380,
				["flare"] = 30,
				["chaff"] = 30,
				["gun"] = 100,
				},
				},
		},
		["Escort"] = {
			["Escort"] = {
				attributes = {},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 500000,
				capability = 10,
				firepower = 10,
				vCruise = 222.22,
				-- vAttack = 265.83333333333,
				-- hCruise = 9753.6,
				-- hAttack = 9753.6,
				standoff = 46300,
				tStation = nil,
				LDSD = true,
				--- self_escort = true,
				sortie_rate = 8,
				stores = {
				["pylons"] = 
				{
					[7] = {
						["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
						["num"] = 7,
					},
					[1] = {
						["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
						["num"] = 1,
					},
					[6] = {
						["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
						["num"] = 6,
					},
					[4] = {
						["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
						["num"] = 2,
					},
					[3] = {
						["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
						["num"] = 3,
					},
					[5] = {
						["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
						["num"] = 5,
					},
					[4] = {
						["CLSID"] = "{2BEC576B-CDF5-4B7F-961F-B0FA4312B841}",
						["num"] = 4,
					},
				}, -- end of ["pylons"]
				["fuel"] = 6404,
				["flare"] = 60,
				["chaff"] = 60,
				["gun"] = 100,
				},
			},
		}
	},			
	["Su-27"] = {
		["Intercept"] = {	
			["Intercept"] = {
				attributes = {},
				weaponType = nil,
				expend = nil,
				day = true,
				night = false,
				adverseWeather = false,
				range = 93000,
				capability = 10,
				firepower = 1,
				vCruise = nil,
				vAttack = nil,
				hCruise = nil,
				hAttack = nil,
				standoff = nil,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 8,
				stores = {
			["pylons"] = {
				[10] = {
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
					["num"] = 10,
				},
				[1] = {
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
					["num"] = 2,
				},
				[9] = {
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
					["num"] = 9,
				},
				[8] = {
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
					["num"] = 8,
				},
				[3] = {
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
					["num"] = 4,
				},
				[5] = {
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
					["num"] = 6,
				},
				[7] = {
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
					["num"] = 7,
				},
			},
				["fuel"] = 9400,
				["flare"] = 96,
				["ammo_type"] = 1,
				["chaff"] = 96,
				["gun"] = 100,
			},
		},
		},
		["CAP"] = {
			["CAP"] = {
				attributes = {},
				weaponType = nil,
				expend = nil,
				day = true,
				night = true,
				adverseWeather = true,
				range = 300000,
				capability =  10,
				firepower = 1,
				vCruise = 180.55,
				vAttack = 222.22,
				hCruise = 6096,
				hAttack = 5500,
				standoff = 45000,
				tStation = 2700,
				LDSD = false,
				self_escort = false,
				sortie_rate = 6,
			stores = {
			["pylons"] = {
				[10] = {
					["CLSID"] = "{44EE8698-89F9-48EE-AF36-5FD31896A82A}",
					["num"] = 10,
				},
				[1] = {
					["CLSID"] = "{44EE8698-89F9-48EE-AF36-5FD31896A82F}",
					["num"] = 1,
				},
				[9] = {
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
					["num"] = 9,
				},
				[2] = {
					["CLSID"] = "{FBC29BFE-3D24-4C64-B81D-941239D12249}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}",
					["num"] = 3,
				},
				[8] = {
					["CLSID"] = "{B79C379A-9E87-4E50-A1EE-7F7E29C2E87A}",
					["num"] = 8,
				},
				[7] = {
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
					["num"] = 7,
				},
				[4] = {
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
					["num"] = 4,
				},
				[6] = {
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
					["num"] = 6,
				},
				[5] = {
					["CLSID"] = "{E8069896-8435-4B90-95C0-01A03AE6E400}",
					["num"] = 5,
				},
			},
				["fuel"] = 9400,
				["flare"] = 96,
				["ammo_type"] = 1,
				["chaff"] = 96,
				["gun"] = 100,
			},
		},
	},
	},	
	["Mi-24V"] = {
		["Strike"] = {
			["Strike Rockets"] = {
				minscore = 0.5,
					support = {
						["Escort"] = false,
						["SEAD"] = false,
					},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				weaponType = "Rockets",
				expend = "Auto",
				day = true,
				night = true,
				adverseWeather = true,
				range = 120000,
				capability = 10,
				firepower = 1,
				vCruise = 50,
				vAttack = 55,
				hCruise = 50,
				hAttack = 50,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 3,
				stores = {
				["pylons"] = {
				[5] = {
					["CLSID"] = "{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}",
					["num"] = 5,
				},
				[2] = {
					["CLSID"] = "{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}",
					["num"] = 2,
				},
				[4] = {
					["CLSID"] = "{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}",
					["num"] = 4,
				},
				[3] = {
					["CLSID"] = "{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
                ["fuel"] = 1704,
                ["flare"] = 192,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
		},
	},
	["Mi-8MT"] = {
		["Strike"] = {
			["Strike Rockets"] = {
				minscore = 0.5,
					support = {
						["Escort"] = false,
						["SEAD"] = false,
					},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				weaponType = "Rockets",
				expend = "Auto",
				day = true,
				night = true,
				adverseWeather = true,
				range = 112000,
				capability = 10,
				firepower = 1,
				vCruise = 40,
				vAttack = 55,
				hCruise = 50,
				hAttack = 50,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 3,
				stores = {
				["pylons"] = {
				[8] = {
					["CLSID"] = "PKT_7_62",
					["num"] = 8,
				},
				[7] = {
					["CLSID"] = "KORD_12_7",
					["num"] = 7,
				},
				[5] = {
					["CLSID"] = "{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}",
					["num"] = 5,
				},
				[6] = {
					["CLSID"] = "{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}",
					["num"] = 6,
				},
				[2] = {
					["CLSID"] = "{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}",
					["num"] = 2,
				},
				[1] = {
					["CLSID"] = "{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}",
					["num"] = 1,
				},
				[3] = {
					["CLSID"] = "{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}",
					["num"] = 3,
				},
				[4] = {
					["CLSID"] = "{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}",
					["num"] = 4,
				},
			}, -- end of ["pylons"]
                ["fuel"] = 1929,
                ["flare"] = 128,
                ["chaff"] = 0,
                ["gun"] = 0,
				},
				["AddPropAircraft"] = 
                                        {
                                            ["ExhaustScreen"] = true,
                                            ["CargoHalfdoor"] = true,
                                            ["GunnersAISkill"] = 90,
                                            ["AdditionalArmor"] = true,
                                            ["NS430allow"] = true,
                                        }, -- end of ["AddPropAircraft"]
			},
		},
	},
	["Ka-50"] = {
		["Strike"] = {
			["Strike"] = {
				minscore = 0.5,
					support = {
						["Escort"] = false,
						["SEAD"] = false,
					},
				attributes = {"soft", "Parked Aircraft", "SAM"},
				weaponType = "Rockets",
				expend = "Auto",
				day = true,
				night = true,
				adverseWeather = true,
				range = 120000,
				capability = 10,
				firepower = 1,
				vCruise = 50,
				vAttack = 61,
				hCruise = 50,
				hAttack = 50,
				standoff = 6000,
				tStation = nil,
				LDSD = false,
				self_escort = false,
				sortie_rate = 3,
				stores = {
				["pylons"] = {
				[4] = {
					["CLSID"] = "{A6FD14D3-6D30-4C85-88A7-8D17BEE120E2}",
					["num"] = 4,
				},
				[1] = {
					["CLSID"] = "{A6FD14D3-6D30-4C85-88A7-8D17BEE120E2}",
					["num"] = 1,
				},
				[2] = {
					["CLSID"] = "{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}",
					["num"] = 2,
				},
				[3] = {
					["CLSID"] = "{6A4B9E69-64FE-439a-9163-3A87FB6A4D81}",
					["num"] = 3,
				},
			}, -- end of ["pylons"]
                ["fuel"] = 1450,
                ["flare"] = 128,
                ["chaff"] = 0,
                ["gun"] = 100,
				},
			},
		},
	},
}
	